## this script was put together by Joel Bruner 2006
## to leave feedbackapps@brunerd.com


#installation: 
#put this script and as adexpire.php in the same directory, set executable bit 

### Variables
# ADdomain might be "All\ Domains" or unique if...
# In the Active Directory Plugin for Directory Service, Advanced Tab
# if you have Allow authenticate from any domain in the forest
# ADdomain="All\ Domains"
# Otherwise it's the FQDN of your AD domain, example: yourcompany.com
ADdomain="your.domain.com"

# Number of days before a password expires can't find this in the AD visible with dscl
# there is another way using rpcclient, would yield more accurate results
pwPolicy=60;


lastPwdSet()
{
userRecord=`dscl localhost -read /Active\ Directory/$ADdomain/Users/$user`

#if the user does not exist it will return a non-zero value
#and this will exit with an error status of 1 for the applescript to catch
if [ $? -ne 0 ]; then
return 1;
fi

# find (grep) and trim off (sed) the extra stuff
#must use quotes for newlines to be preserved with echo, otherwise grep uses ENTIRE record
lastpwdMS=`echo "$userRecord" | grep -i pwdLastSet | sed 's/pwdLastSet: //'`

#get todays date in Unix time
todayUnix=`date "+%s"`
# this formula converts the AD time format to UNIX time
# from http://support.citrix.com/article/CTX109645
lastpwdUnix=`expr $lastpwdMS / 10000000 - 11644473600`

#a different formula, there is a difference 74286 seconds... not sure which to use
#from http://www.microsoft.com/technet/scriptcenter/topics/win2003/lastlogon.mspx
#lastpwdAD2Unix=`echo "(($lastpwdMS / 600000000) / 1440 - 134774) * 86400" | bc`

#get the difference in times in Unix time (in seconds)
diffUnix=`expr $todayUnix - $lastpwdUnix`
#diffADUNix=`expr $lastpwdUnix - $lastpwdAD2Unix`

# make that into days
diffdays=`expr $diffUnix / 86400`
#let us know
echo $diffdays
}


#if string is empty run as current user
#this is nice for local command line use
#although might yield odd results when run via php with no arguments
if [ -z $1 ]; then
user=`whoami`
else
user=$1
fi


#query the server with the username
daysago=`lastPwdSet $user`;
#just in case the last function failed then stop
if [ $? -ne 0 ]; then exit; fi


#echo $lastpwdAD2Unix - $lastpwdUnix

daysremaining=`expr $pwPolicy - $daysago`
echo $daysremaining
